<x-app-layout>
    <x-slot name="header">
        Category
    </x-slot>

    <!-- Row -->
    <div class="row">
        <div class="col-md-10">
            <div class="card">
                <div class="card-header">
                    <div class="card-title">
                        @isset($category->id)
                        Edit Category
                        @else
                        Add New Category
                        @endisset
                    </div>
                </div>
                <form action="
                    @isset($category->id)
                        {{ route('admin.category.update', [$type, $category->id]) }}
                    @else
                        {{ route('admin.category.store', $type) }}
                    @endisset
                    " method="post" enctype="multipart/form-data">
                    <div class="card-body">
                        @isset($category->id)
                        @method('PUT')
                        @endisset
                        @csrf
                        <div class="row mb-4">
                            <label class="col-md-3 form-label" id="name">Category Name :</label>
                            <div class="">
                                <input required type="search" class="form-control @error('name') is-invalid @enderror"
                                    name="name" value="{{ old('name', $category->name) }}" placeholder="Category Name">
                            </div>
                            @error('name')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="row mb-4">
                            <label class="col-md-3 form-label" id="thumbnail">Icon :</label>
                            <div class="">
                                <input type="file" class="form-control @error('thumbnail') is-invalid @enderror" name="thumbnail"
                                    value="{{ old('thumbnail', $category->thumbnail) }}" placeholder="Category thumbnail"
                                    accept=".jpg, .png, image/jpeg, image/png">
                            </div>
                            @error('thumbnail')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>

                        <div class="row mb-4">
                            <label class="col-md-3 form-label" id="description">Category Details:</label>
                            <div class="">
                                <textarea name="description" class="content @error('description') is-invalid @enderror" placeholder="Category description">{{ old('description', $category->description) }}</textarea>
                            </div>
                            @error('description')
                            <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        <label class="custom-switch form-switch me-5">
                            <input type="checkbox" name="status" value="1" class="custom-switch-input" {{ old('status',
                                $category->status) == 1 ? 'checked' : '' }}>
                            <span class="custom-switch-indicator custom-switch-indicator-lg"></span>
                            <span class="custom-switch-description">Status</span>
                        </label>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">Save</button>
                        <a href="{{route('admin.category.index', $type)}}"
                            class="btn btn-default float-end">Discard</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- End Row -->
    <x-slot name="script">
        <script src="{{asset('backend/plugins/wysiwyag/jquery.richtext.js')}}"></script>
        <script src="{{asset('backend/plugins/wysiwyag/wysiwyag.js')}}"></script>
        <script>
            $(document).ready(function () {
            });
        </script>
    </x-slot>

</x-app-layout>
